unit ColorPaletteEditor;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ColorPalette, Utility, Spin;

type
  TfrmColorPaletteEditor = class( TForm )
    Label1: TLabel;
    dfIndex: TPanel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    pbOK: TButton;
    pbModify: TButton;
    pbCancel: TButton;
    ColorPalette1: TColorPalette;
    ColorDialog1: TColorDialog;
    pbLoad: TButton;
    pbSave: TButton;
    dlgOpen: TOpenDialog;
    dlgSave: TSaveDialog;
    spinRed: TSpinEdit;
    spinGreen: TSpinEdit;
    spinBlue: TSpinEdit;
    procedure dfRedKeyPress(Sender: TObject; var Key: Char);
    procedure pbPalPaint(Sender: TObject);
    procedure pbPalMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormShow(Sender: TObject);
    procedure dfRedKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure pbModifyClick(Sender: TObject);
    procedure pbLoadClick(Sender: TObject);
    procedure pbSaveClick(Sender: TObject);
    procedure spinRedChange(Sender: TObject);
    procedure FormDblClick(Sender: TObject);
  private
    nIndex: integer;
    bCreated: boolean;
    bNo: boolean;
    function GetPalette: HPalette; override;
    procedure ModifyEntry;
  public
  end;

var
  frmColorPaletteEditor: TfrmColorPaletteEditor;

implementation

{$R *.DFM}

procedure TfrmColorPaletteEditor.dfRedKeyPress(Sender: TObject;
  var Key: Char);
begin
  if Key in [Chr( vk_Tab ),Chr( vk_Back )] then
     Exit;
  if ( Key < '0' ) or ( Key > '9' ) then
     Key := #0;
end;

function TfrmColorPaletteEditor.GetPalette: HPalette;
begin
  Result := ColorPalette1.Palette;
end;

procedure TfrmColorPaletteEditor.pbPalPaint(Sender: TObject);
var
  x, y: integer;
  rectFill: TRect;
begin
  SelectPalette( Canvas.Handle, ColorPalette1.Palette, FALSE );
  RealizePalette( Canvas.Handle );
  Canvas.Brush.Style := bsSolid;
  for x := 0 to 15 do
    for y := 0 to 15 do
     begin
       Canvas.Brush.Color := PaletteIndex( y * 16 + x );
       rectFill.Left := x * 16 + 8;
       rectFill.Top := y * 16 + 8;
       rectFill.Right := rectFill.Left + 15;
       rectFill.Bottom := rectFill.Top + 15;
       Canvas.FillRect( rectFill );
     end;
  Canvas.Pen.Color := clYellow;
  Canvas.Brush.Style := bsClear;
  x := nIndex mod 16 * 16 + 8;
  y := nIndex div 16 * 16 + 8;
  Canvas.Rectangle( x, y, x + 15, y + 15 );
end;

procedure TfrmColorPaletteEditor.pbPalMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  x_, y_: integer;
begin
  x_ := (X - 8) div 16;
  y_ := (Y - 8) div 16;
  if (x_ < 0) or (x_ > 15) then
    Exit;
  if (y_ < 0) or (y_ > 15) then
    Exit;
  nIndex := y_ * 16 + x_;
  dfIndex.Caption := IntToStr( nIndex );
  bNo := true;
  spinRed.Value := ColorPalette1.PaletteEntry[nIndex].peRed;
  spinGreen.Value := ColorPalette1.PaletteEntry[nIndex].peGreen;
  spinBlue.Value := ColorPalette1.PaletteEntry[nIndex].peBlue;
  Paint;
  bNo := false;
end;

procedure TfrmColorPaletteEditor.FormShow(Sender: TObject);
begin
  if bCreated then
     Exit;
  nIndex := 0;
  pbPalMouseUp( self, mbLeft, [], 1, 1 );
  bCreated := TRUE;
end;

procedure TfrmColorPaletteEditor.ModifyEntry;
var
  pe: TPaletteEntry;
begin
  pe.peRed := spinRed.Value;
  pe.peGreen := spinGreen.Value;
  pe.peBlue := spinBlue.Value;
  pe.peFlags := ColorPalette1.PaletteEntry[nIndex].peFlags;
  ColorPalette1.PaletteEntry[nIndex] := pe;
  bNo := true;
  Paint;
  bNo := false;
end;

procedure TfrmColorPaletteEditor.dfRedKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  ModifyEntry;
end;

procedure TfrmColorPaletteEditor.pbModifyClick(Sender: TObject);
var
  nRGB: longint;
begin
  with ColorDialog1 do
  begin
    Color := RGB( spinRed.Value, spinGreen.Value, spinBlue.Value );
    if Execute then
    begin
      nRGB := ColorToRGB( Color );
      bNo := true;
      spinRed.Value := GetRValue( nRGB );
      spinGreen.Value := GetGValue( nRGB );
      spinBlue.Value := GetBValue( nRGB );
      bNo := false;
      ModifyEntry;
    end;
  end;
end;

procedure TfrmColorPaletteEditor.pbLoadClick(Sender: TObject);
var
  strOpen: TStrings;
  i: integer;
  sLine, sEntry: string;
begin
  if dlgOpen.Execute then
     begin
        dlgSave.FileName := dlgOpen.FileName;
        strOpen := TStringList.Create;
        strOpen.LoadFromFile( dlgOpen.FileName );
        for i := 0 to 255 do
           begin
              sLine := strOpen[i + 3];
              sEntry := GetToken( sLine, ' ' ) + ',' +
                 GetToken( sLine, ' ' ) + ',' +
                 GetToken( sLine, ' ' ) + ',' + IntToStr( PC_NOCOLLAPSE );
              ColorPalette1.PaletteEntries[i] := sEntry;
           end;
        ColorPalette1.Refresh;
        spinRed.Value := ColorPalette1.PaletteEntry[nIndex].peRed;
        spinGreen.Value := ColorPalette1.PaletteEntry[nIndex].peGreen;
        spinBlue.Value := ColorPalette1.PaletteEntry[nIndex].peBlue;
        ModifyEntry;
        strOpen.Free;
     end;
end;

procedure TfrmColorPaletteEditor.pbSaveClick(Sender: TObject);
var
  strSave: TStrings;
  i: integer;
  sLine, sEntry: string;
begin
  if dlgSave.Execute then
     begin
        strSave := TStringList.Create;
        strSave.Add( 'JASC-PAL' );
        strSave.Add( '0100' );
        strSave.Add( '256' );
        for i := 0 to 255 do
           begin
              sLine := ColorPalette1.PaletteEntries[i];
              sEntry := GetToken( sLine, ',' ) + ' ' +
                 GetToken( sLine, ',' ) + ' ' +
                 GetToken( sLine, ',' );
              strSave.Add( sEntry );
           end;
        strSave.SaveToFile( dlgSave.FileName );
        strSave.Free;
     end;
end;

procedure TfrmColorPaletteEditor.spinRedChange(Sender: TObject);
begin
  if not bNo then
    ModifyEntry;
end;

procedure TfrmColorPaletteEditor.FormDblClick(Sender: TObject);
begin
  pbModifyClick( self );
end;

end.
